<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Country extends Model 
{

    protected $table = 'countrys';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('currency_id', 'slug', 'short_name', 'name', 'iso_code', 'phone_code', 'flag', 'status');
    protected $visible = array('currency_id', 'slug', 'short_name', 'name', 'iso_code', 'phone_code', 'flag', 'status');

    public function intervals()
    {
        return $this->hasMany('App\Models\Interval', 'country_id');
    }

    public function exchanges()
    {
        return $this->hasMany('App\Models\Exchange', 'country_withdrawal_id');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_id');
    }

    public function transfers()
    {
        return $this->hasMany('App\Models\Transfer', 'beneficiary_country_id');
    }

    public function partners()
    {
        return $this->hasMany('App\Models\Partner', 'country_id');
    }

    public function agencies()
    {
        return $this->hasMany('App\Models\Agency', 'country_id');
    }

    public function transferFees()
    {
        return $this->hasMany('App\Models\TransferFee', 'country_id');
    }

}